package com.yeejoin.amos.boot.module.common.biz.utils;

import com.alibaba.fastjson.JSON;
import com.yeejoin.amos.boot.module.common.api.enums.EquipmentClassifityEnum;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RefreshDataUtils {

    /**
     * 判断字符串是否为合法的 JSON 格式
     */
    public static boolean isJSONValid(String test) {
        try {
            JSON.parseArray(test);
            return true;
        } catch (Exception ex) {
            return false;
        }
    }

    public static String castStrList2String(String jsonTypesStr) {
        if (!isNullOrEmpty(jsonTypesStr)) {
            if (isJSONValid(jsonTypesStr)) {
                List<String> posts = JSON.parseArray(jsonTypesStr, String.class);
                return String.join(",", posts);
            }
            return jsonTypesStr;
        }
        return null;
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.trim().isEmpty() || "null".equals(str);
    }

    public static String castEquCategory2Name(String equipTypes) {
        Set<String> names = new HashSet<>();
        if(!isNullOrEmpty(equipTypes)){
            for (String equipType : equipTypes.split(",")) {
                names.add(EquipmentClassifityEnum.getNameByCode(equipType));
            }
        }
        names.remove("");
        return String.join(",", names);
    }

}
