package com.yeejoin.amos.boot.module.jg.api.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.mapper.CustomBaseMapper;
import com.yeejoin.amos.boot.module.jg.api.dto.CompanyEquipCountDto;
import com.yeejoin.amos.boot.module.jg.api.dto.JgTransferNoticeDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgTransferNotice;
import com.yeejoin.amos.boot.module.jg.api.vo.SortVo;
import com.yeejoin.amos.boot.module.jg.api.vo.tableDataExportVo.TransferVo;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 移装造告知 Mapper 接口
 *
 * @author system_generator
 * @date 2023-12-19
 */
public interface JgTransferNoticeMapper extends CustomBaseMapper<JgTransferNotice> {

    Page<Map<String, Object>> queryForPage(Page<JgTransferNotice> page,
                                           @Param("sort") SortVo sortMap,
                                           @Param("param") JgTransferNoticeDto model,
                                           @Param("type") String type,
                                           @Param("companyCode") String companyCode,
                                           @Param("orgCode") String orgCode);

    @MapKey("sequenceNbr")
    List<Map<String, Object>> queryEquipInformation(@Param("sequenceNbr") long sequenceNbr);

    List<CompanyEquipCountDto> queryForFlowingEquipList();

    List<TransferVo> queryTransferInIds(@Param("ids") List<String> ids);
}
