package com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.maintainNotice;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.jg.api.dto.FieldChangeMeta;
import com.yeejoin.amos.boot.module.jg.api.entity.JgInstallationNotice;
import com.yeejoin.amos.boot.module.jg.api.entity.JgInstallationNoticeEq;
import com.yeejoin.amos.boot.module.jg.api.entity.JgMaintainNotice;
import com.yeejoin.amos.boot.module.jg.api.entity.JgMaintainNoticeEq;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgInstallationNoticeServiceImpl;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgMaintainNoticeEqServiceImpl;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgMaintainNoticeServiceImpl;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Service
@RequiredArgsConstructor
@Getter
public class MaintainNoticeEditUpdateService {

    private final JgMaintainNoticeServiceImpl maintainNoticeService;

    private final JgMaintainNoticeEqServiceImpl maintainNoticeEqService;

    public Set<String> getEqsByApplyNo(String applyNo) {
        JgMaintainNotice jgInstallationNotice = maintainNoticeService.getOne(new LambdaQueryWrapper<JgMaintainNotice>().eq(JgMaintainNotice::getApplyNo, applyNo).select(BaseEntity::getSequenceNbr));
        List<JgMaintainNoticeEq> eqs = maintainNoticeEqService.list(new LambdaQueryWrapper<JgMaintainNoticeEq>().eq(JgMaintainNoticeEq::getEquipTransferId, jgInstallationNotice.getSequenceNbr()).select(JgMaintainNoticeEq::getEquId, BaseEntity::getSequenceNbr));
        return eqs.stream().map(JgMaintainNoticeEq::getEquId).collect(Collectors.toSet());
    }

    public JgMaintainNotice getOneByApplyNo(String applyNo) {
        return maintainNoticeService.getOne(new LambdaQueryWrapper<JgMaintainNotice>().eq(JgMaintainNotice::getApplyNo, applyNo));
    }

}