package com.yeejoin.amos.boot.module.jg.biz.reminder.biz.vehicleInformation;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgVehicleInformationEqMapper;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgVehicleInformationMapper;
import com.yeejoin.amos.boot.module.jg.biz.reminder.service.CommonReminderService;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.CommonServiceImpl;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgFactoryInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgUseInfo;
import com.yeejoin.amos.boot.module.ymt.api.mapper.IdxBizJgFactoryInfoMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.IdxBizJgRegisterInfoMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.IdxBizJgUseInfoMapper;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

@Component
@RequiredArgsConstructor
@Getter
public class VehicleInformationReminderParse {

    private final JgVehicleInformationMapper vehicleInformationMapper;

    private final JgVehicleInformationEqMapper vehicleInformationEqMapper;

    private final IdxBizJgRegisterInfoMapper idxBizJgRegisterInfoMapper;

    private final IdxBizJgUseInfoMapper idxBizJgUseInfoMapper;

    private final CommonReminderService commonReminderService;

    private final CommonServiceImpl jgCommonService;

    private final IdxBizJgFactoryInfoMapper jgFactoryInfoMapper;

    public Map<String, Object> getEquipDetailByRecord(String record) {
        IdxBizJgFactoryInfo factoryInfo = jgFactoryInfoMapper.selectOne(new LambdaQueryWrapper<IdxBizJgFactoryInfo>().eq(IdxBizJgFactoryInfo::getRecord, record));
        IdxBizJgUseInfo useInfo = idxBizJgUseInfoMapper.selectOne(new LambdaQueryWrapper<IdxBizJgUseInfo>().eq(IdxBizJgUseInfo::getRecord, record));
        Map<String, Object> result = new HashMap<>();
        result.put("USE_INNER_CODE", useInfo.getUseInnerCode());
        result.put("FACTORY_NUM", factoryInfo.getFactoryNum());
        return result;
    }

}
