package com.yeejoin.amos.boot.module.jyjc.biz.event.rule;

import com.yeejoin.amos.boot.module.jyjc.biz.event.IRuleDataPrepare;
import com.yeejoin.amos.boot.module.jyjc.biz.event.InspectionOrgRefreshEvent;
import com.yeejoin.amos.boot.module.jyjc.biz.event.rule.service.EnableRuleDataPreparationService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Component
@Slf4j
@RequiredArgsConstructor
public class EnableRuleDataPrepareHandler implements IRuleDataPrepare {
    private final EnableRuleDataPreparationService preparationService;
    @Override
    public Boolean supportType() {
        return true;
    }

    @Override
    public void handle(InspectionOrgRefreshEvent event) {
        preparationService.onApplicationEvent(event);
    }
}
