package com.yeejoin.amos.boot.module.ymt.api.enums;

import lombok.Getter;

/**
 * 流程办理状态统一枚举
 */
@Getter
public enum FlowStatusEnum {

    /**
     * 已转办
     */
    TO_BE_TRANSFER(6621, "已转办"),

    /**
     * 待提交
     */
    TO_BE_SUBMITTED(6610, "待提交"),
    /**
     * 检测检测专用 已废弃 勿删
     * */
    @Deprecated
    TO_SUBMITTED(6611, "待受理"),
    /**
     * 待受理
     */
    TO_BE_PROCESSED(6612, "待受理"),

    /**
     * 已驳回
     */
    REJECTED(6614, "已驳回"),

    /**
     * 已撤回
     */
    ROLLBACK(6615, "已撤回"),
    /**
     * 已完成
     */
    TO_BE_FINISHED(6616, "已完成"),
    /**
     * 已作废
     */
    TO_BE_DISCARD(6617, "已作废"),

    /**
     * 不予受理
     */
    NO_ACCEPT(6618, "不予受理");

    private final int code;

    private final String name;

    FlowStatusEnum(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public static String getNameByType(Long code) {
        String name = null;
        for (FlowStatusEnum enumOne : FlowStatusEnum.values()) {
            if (enumOne.getCode() == code) {
                name = enumOne.getName();
                break;
            }
        }
        return name;
    }

    public static FlowStatusEnum getEumByCode(int code) {

        for (FlowStatusEnum statusEnum : FlowStatusEnum.values()) {
            if (statusEnum.getCode() == code) {
                return statusEnum;
            }
        }
        return null;
    }

    public static FlowStatusEnum getEumByName(String name) {
        for (FlowStatusEnum statusEnum : FlowStatusEnum.values()) {
            if (statusEnum.getName().equals(name)) {
                return statusEnum;
            }
        }
        return null;
    }

}