package com.yeejoin.amos.boot.module.ymt.biz.service.impl;

import com.yeejoin.amos.boot.module.ymt.api.dto.ElevatorListDto;
import com.yeejoin.amos.boot.module.ymt.api.dto.ElevatorRelationDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.ElevatorRelation;
import com.yeejoin.amos.boot.module.ymt.api.mapper.ElevatorRelationMapper;
import com.yeejoin.amos.boot.module.ymt.api.service.IElevatorRelationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.List;

/**
 * 关注电梯关系表服务实现类
 *
 * @author system_generator
 * @date 2021-10-08
 */
@Service
public class ElevatorRelationServiceImpl extends BaseService<ElevatorRelationDto, ElevatorRelation, ElevatorRelationMapper> implements IElevatorRelationService {

    private final Logger logger = LoggerFactory.getLogger(ElevatorRelationServiceImpl.class);

    @Override
    public Boolean hasFocusElevator(String phone, Long elevatorId) {
        return baseMapper.hasFocusElevator(phone, elevatorId) == 1;
    }

    @Override
    public Boolean focusElevator(String openId, String elevatorId) {
        Boolean flag = false;
        try {
            int result = baseMapper.focusElevator(openId, elevatorId);
            flag = true;
        } catch (Exception e) {
            logger.error("关注电梯失败" + e.getMessage());
        }

        return  flag;
    }

    @Override
    public Boolean cancelFocusElevator(String openId, String elevatorId) {
        return baseMapper.cancelFocusElevator(openId, elevatorId) == 1;
    }

    @Override
    public List<ElevatorListDto> getMyFocusElevator(String openId) {
        return baseMapper.getMyFocusElevator(openId);
    }
}