package com.yeejoin.amos.api.openapi.face.orm.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

import java.util.Date;

/**
 * 许可详细信息表
 *
 * @author duanwei
 * @date 2022-08-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel(value="TaLicenseDetailInfo对象", description="许可详细信息表")
public class TaLicenseDetailInfo extends BaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "id")
    private String id;

    @ApiModelProperty(value = "base_info表id")
    private String basicInfoId;

    @ApiModelProperty(value = "单位统一社会信用代码")
    private String unitCode;

    @ApiModelProperty(value = "证书编号")
    private String certNo;

    @ApiModelProperty(value = "许可项目")
    private String itemName;

    @ApiModelProperty(value = "许可子项目")
    private String subItem;

    @ApiModelProperty(value = "许可参数")
    private String parameter;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "固定检验地址")
    private String itemAddress;

    @ApiModelProperty(value = "数据入库时间")
    private Date recordDate;



    @ApiModelProperty(value = "同步时间")
    private Date syncDate;

    @ApiModelProperty(value = "同步状态（0-新增   1-更新   2-删除）")
    private Integer syncState;


}
