package com.yeejoin.amos.api.openapi.face.model;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * <p>
 * 检验信息
 * </p>
 *
 * @author 子杨
 * @since 2021-12-17
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class SpecialInspectModel extends AbstractBaseModel {

    private static final long serialVersionUID = 1L;
    /**
     * 设备全省唯一编号
     */
    private String sequenceCode;
    /**
     * 检验信息唯一ID
     */
    private String inspectInfoId;
    /**
     * 检验日期
     */
    private String inspectDate;
    /**
     * 检验类别
     */
    private String inspectCategory;
    /**
     * 检验结论
     */
    private String inspectConclusion;
    /**
     * 报告书编号
     */
    private String reportCode;
    /**
     * 下次检验日期
     */
    private String nextInspectDate;
    /**
     * 检验员姓名
     */
    private String inspectorName;
    /**
     * 报告出具日期
     */
    private String reportDate;
    /**
     * 检验机构统一信用代码
     */
    private String inspectOrgCreditCode;
    /**
     * 检验机构名称
     */
    private String inspectOrgCreditName;
    /**
     * 检验报告
     */
    private List<OpenapiFilesModel> inspectReport;

}
