package com.yeejoin.amos.api.openapi.face.orm.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 特种设备附件资料信息
 *
 * @author duanwei
 * @date 2022-07-20
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Accessors(chain = true)
@TableName("tm_jg_enclosure_info")
@ApiModel(value="TmJgEnclosureInfo对象", description="特种设备附件资料信息")
public class EnclosureInfo extends AbstractBaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "设备资料编号")

    private String equDataNo;

    @ApiModelProperty(value = "设备唯一标识码")
    private String sequenceCode;

    @ApiModelProperty(value = "监管系统唯一编码")
    private String superviseCode;

    @ApiModelProperty(value = "设备资料类型")
    private String equDataType;

    @ApiModelProperty(value = "附件资料格式")
    private String enclosureFormat;

    @ApiModelProperty(value = "附件资料名称")
    private String enclosureName;

    @ApiModelProperty(value = "附件资料完整路径")
    private String enclosureUrl;

}
