package com.yeejoin.amos.boot.module.ccs.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.annotation.TableField;

/**
 * 电力设备资产
 *
 * @author system_generator
 * @date 2021-11-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "EquipmentDto", description = "电力设备资产")
public class EquipmentDto extends BaseDto {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "站点编码")
    private String stationCode;

    @ApiModelProperty(value = "站点名称")
    private String stationName;


    
    @ApiModelProperty(value = "电力设备唯一标识")
    private String mrid;

    @ApiModelProperty(value = "名称")
    private String name;

    @ApiModelProperty(value = "所属区域mrid")
    private String areaMrid;

    @ApiModelProperty(value = "所属区域")
    private String workArea;
    
    
    @ApiModelProperty(value = "所属建筑mrid")
    private String buildMrid;

    @ApiModelProperty(value = "所属建筑")
    private String buildName;
    
   
    @ApiModelProperty(value = "所属楼层mrid")
    private String floorMrid;

    @ApiModelProperty(value = "所属楼层")
    private String floorName;
    
   
    @ApiModelProperty(value = "所属房间mrid")
    private String roomMrid;

   
    @ApiModelProperty(value = "所属房间")
    private String roomName;

  
    @ApiModelProperty(value = "地址")
    private String address;

    @ApiModelProperty(value = "设备图片，多条以,隔开")
    private List<String> img;


    @ApiModelProperty(value = " 电源负荷图，多条以,隔开")
    private List<String> powerImg;

   
    @ApiModelProperty(value = " 封堵图，多条以,隔开")
    private List<String> pluggingImg;

   
    @ApiModelProperty(value = "行车路线图，多条以,隔开")
    private List<String> routeImg;

  
    @ApiModelProperty(value = "取水图,多条以,隔开")
    private List<String> fetchWaterImg;

  
    @ApiModelProperty(value = "责任部门")
    private String chargeDept;

   
    @ApiModelProperty(value = "责任人")
    private String chargeUser;

}
