package com.yeejoin.amos.boot.module.ccs.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 消防系统信息
 *
 * @author system_generator
 * @date 2021-11-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FireFightingSystemDto", description = "消防系统信息")
public class FireFightingSystemDto extends BaseDto {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "站点名称")
    private String stationName;

    @ApiModelProperty(value = "站点编码")
    private String stationCode;

    @ApiModelProperty(value = "名称")
    private String name;

    @ApiModelProperty(value = "资产id")
    private String mrid;

    @ApiModelProperty(value = "安装日期")
    private String installDate;

    @ApiModelProperty(value = "负责人")
    private String chargePerson;

    @ApiModelProperty(value = "负责人电话")
    private String chargePersonPhone;

    @ApiModelProperty(value = "施工单位")
    private String constructionUnit;

    @ApiModelProperty(value = "维保单位")
    private String maintenanceUnit;

    @ApiModelProperty(value = "首次维保日期")
    private Date firstMaintenanceDate;

    @ApiModelProperty(value = "维保频率")
    private String maintenanceFrequency;

    @ApiModelProperty(value = "维保电话")
    private String maintenancePhone;

    @ApiModelProperty(value = "修改时间")
    private Date updateDate;

    @ApiModelProperty(value = "经度")
    private String lng;

    @ApiModelProperty(value = "纬度")
    private String lat;

}
