package com.yeejoin.amos.boot.module.ccs.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 风险点表
 *
 * @author system_generator
 * @date 2021-11-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FireRiskSourceDto", description = "风险点表")
public class FireRiskSourceDto extends BaseDto {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "站点编码")
    private String stationCode;

    @ApiModelProperty(value = "站点名称")
    private String stationName;

    @ApiModelProperty(value = "唯一标识")
    private String mrid;

    @ApiModelProperty(value = "装备名称")
    private String name;

    @ApiModelProperty(value = "上级编号id")
    private String parentMrid;

    @ApiModelProperty(value = "风险等级id")
    private String riskLevelMrid;

    @ApiModelProperty(value = "风险等级名称")
    private String riskLevelName;

    @ApiModelProperty(value = "风险等级颜色")
    private String riskLevelColor;

    @ApiModelProperty(value = "rpni属性")
    private BigDecimal rpni;

    @ApiModelProperty(value = "实时rpn")
    private BigDecimal rpn;

    @ApiModelProperty(value = "状态(正常normal，异常anomaly)")
    private String status;

    @ApiModelProperty(value = "rpn增量")
    private BigDecimal increment;

    private String isRegion;

}
