package com.yeejoin.amos.boot.module.ccs.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 电力设备表
 *
 * @author system_generator
 * @date 2021-11-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("ast_equipment")
public class Equipment extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 站点编码
     */
    @TableField("station_code")
    private String stationCode;

    /**
     * 站点名称
     */
    @TableField("station_name")
    private String stationName;

    /**
     * 消防建筑唯一标识
     */
    @TableField("mrid")
    private String mrid;

    /**
     * 名称
     */
    @TableField("name")
    private String name;

    /**
     * 所属区域
     */
    @TableField("area_mrid")
    private String areaMrid;

    /**
     * 所属区域
     */
    @TableField("work_area")
    private String workArea;
    
    
    @TableField("build_mrid")
    private String buildMrid;

    /**
     * 所属建筑
     */
    @TableField("build_name")
    private String buildName;
    
   
    @TableField("floor_mrid")
    private String floorMrid;

    /**
     * 所属楼层
     */
    @TableField("floor_name")
    private String floorName;
    
   
    @TableField("room_mrid")
    private String roomMrid;

    /**
     * 所属房间
     */
    @TableField("room_name")
    private String roomName;

    /**
     * 地址
     */
    @TableField("address")
    private String address;

  
    /**
     * 设备图片，多条以,隔开
     */
    @TableField("img")
    private String img;


    /**
     * 电源负荷图，多条以,隔开
     */
    @TableField("power_img")
    private String powerImg;

    /**
     * 封堵图，多条以,隔开
     */
    @TableField("plugging_img")
    private String pluggingImg;

    /**
     * 行车路线图，多条以,隔开
     */
    @TableField("route_img")
    private String routeImg;

    /**
     * 取水图,多条以,隔开
     */
    @TableField("fetch_water_img")
    private String fetchWaterImg;

    /**
     * 责任部门
     */
    @TableField("charge_dept")
    private String chargeDept;

    /**
     * 责任人
     */
    @TableField("charge_user")
    private String chargeUser;
    
  

}
