package com.yeejoin.amos.boot.module.common.api.entity;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
*
*
* @author system_generator
* @date 2021-06-29
*/
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("cb_water_resource_pool")
public class WaterResourcePool extends BaseEntity {

    private static final long serialVersionUID = 1L;


    /**
	  * 资源id
     */
	@TableField("resource_id")
    private Long resourceId;
    /**
	  * 容积（m³）
     */
	@TableField("volume")
    private Float volume;
    /**
	  * 水源可用状态类别代码
     */
	@TableField("status_code")
    private String statusCode;
    /**
	  * 水源可用状态类别名称
     */
	@TableField("status")
    private String status;
    /**
	  * 所属路段
     */
	@TableField("section")
    private String section;
    /**
	  * 取水方式
     */
	@TableField("intake_form")
    private String intakeForm;
    /**
	  * 取水高度(cm)
     */
	@TableField("intake_height")
    private Float intakeHeight;
    /**
	  * 水源标高差(cm)
     */
	@TableField("elevation_difference")
    private Float elevationDifference;
    /**
	  * 停车位置
     */
	@TableField("parking_position")
    private String parkingPosition;
    /**
	  * 停车数量(个)
     */
	@TableField("parking_num")
    private int parkingNum;
    /**
	  * 消防给水管网形式类型代码
     */
	@TableField("pipe_type_code")
    private String pipeTypeCode;
    /**
	  * 消防给水管网形式类型名称
     */
	@TableField("pipe_type_name")
    private String pipeTypeName;
    /**
	  * 供水单位名称
     */
	@TableField("water_supply_name")
    private String waterSupplyName;

    /**
     * 最低报警水位
     */
    @TableField("min_water_level")
    private Float minWaterLevel;

    /**
     * 最高报警水位
     */
    @TableField("max_water_level")
    private Float maxWaterLevel;

    /**
     * 水池液位显示装置id
     */
    @TableField("level_device_id")
    private String levelDeviceId;

    /**
     * 水池液位显示装置名称
     */
    @TableField("level_device_name")
    private String levelDeviceName;

    /**
     * 消防泵装置ids
     */
    @TableField("pump_device_id")
    private String pumpDeviceId;

    /**
     * 消防泵装置名称s
     */
    @TableField("pump_device_name")
    private String pumpDeviceName;

    /**
     * 出口流量（L/s）
     */
    @TableField("output_flow_rate")
    private Float outputFlowRate;
}
