package com.yeejoin.equipmanage.common.datasync.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * @ProjectName: YeeFireDataProcessRoot
 * @Package: com.yeejoin.equipmanage.common.datasync.entity
 * @ClassName: GeographicalRegion
 * @Author: Jianqiang Gao
 * @Description: 消防车辆
 * @Date: 2021/3/24 11:10
 * @Version: 1.0
 */
@Data
@Accessors(chain = true)
@TableName("ast_firevehicle")
@ApiModel(value = "FireVehicle对象", description = "消防车辆数据")
public class FireVehicle implements Serializable {

    private static final long serialVersionUID = 5045486925866796088L;

    @ApiModelProperty(value = "ID")
    @TableId("id")
    private String id;

    @ApiModelProperty(value = "CIM的ID")
    @TableField("mrid")
    private String mRid;

    @ApiModelProperty(value = "站点名称")
    @TableField("stationname")
    private String stationName;

    @ApiModelProperty(value = "站点编码")
    @TableField("stationcode")
    private String stationCode;

    @ApiModelProperty(value = "名称")
    @TableField("name")
    private String name;

    @ApiModelProperty(value = "车辆号")
    @TableField("number")
    private String number;

    @ApiModelProperty(value = "车辆类别名称")
    @TableField("type")
    private String type;

    @ApiModelProperty(value = "规格型号")
    @TableField("standard")
    private String standard;

    @ApiModelProperty(value = "厂商")
    @TableField("manufacturer")
    private String manufacturer;

    @ApiModelProperty(value = "品牌")
    @TableField("brand")
    private String brand;

    @ApiModelProperty(value = "国别")
    @TableField("country")
    private String country;

    @ApiModelProperty(value = "底盘国别")
    @TableField("chassiscountry")
    private String chassisCountry;

    @ApiModelProperty(value = "底盘品牌")
    @TableField("chassisbrand")
    private String chassisBrand;

    @ApiModelProperty(value = "物联编码")
    @TableField("iotcode")
    private String iotCode;

    @ApiModelProperty(value = "车辆状态")
    @TableField("state")
    private String state;

    @ApiModelProperty(value = "维保单位")
    @TableField("maintenanceunit")
    private String maintenanceUnit;

    @ApiModelProperty(value = "首次维保日期")
    @TableField("firstmaintenancedate")
    private String firstMaintenancedate;

    @ApiModelProperty(value = "维保频率")
    @TableField("maintenancefrequency")
    private Date maintenanceFrequency;

    @ApiModelProperty(value = "维保电话")
    @TableField("maintenancephone")
    private String maintenancePhone;

    @ApiModelProperty(value = "创建时间")
    @TableField("createdate")
    private Date createDate;

    @ApiModelProperty(value = "修改时间")
    @TableField("updatedate")
    private Date updateDate;

    @ApiModelProperty(value = "别名")
    @TableField("aliasname")
    private String aliasname;

    @ApiModelProperty(value = "描述")
    @TableField("description")
    private String description;

    @ApiModelProperty(value = "里程表计读数时间")
    @TableField("odometerreaddatetime")
    private String odometerreaddatetime;

    @ApiModelProperty(value = "里程表计读数")
    @TableField("odometerreading")
    private String odometerreading;

    @ApiModelProperty(value = "用途种类")
    @TableField("usagekind")
    private String usagekind;

    @ApiModelProperty(value = "车辆类别编码")
    @TableField("typecode")
    private String typecode;

}