package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@Data
@TableName("wl_equip_qrcode_record")
@ApiModel(value = "装备二维码报警及消除记录", description = "装备二维码报警及消除记录")
public class EquipQrcodeRecord extends BaseEntity {
    @ApiModelProperty(value = "设备id")
    @TableField("equip_id")
    private Long equipid;

    @ApiModelProperty(value = "消除时间")
    @TableField("clean_time")
    private Date cleanTime;

    @ApiModelProperty(value = "告警时间")
    @TableField("alarm_time")
    private Date alarmTime;

    @ApiModelProperty(value = "来源")
    @TableField("source")
    private String source;

    @ApiModelProperty(value = "来源id alarm表或p_check_input")
    @TableField("source_id")
    private String sourceId;

    @ApiModelProperty(value = "状态(0:绿码,1:黄码,2:红码)")
    @TableField("status")
    private String status;

    @ApiModelProperty(value = "状态(0:绿码,1:黄码,2:红码)")
    @TableField("biz_org_code")
    private String bizOrgCode;

    @ApiModelProperty(value = "状态(0:绿码,1:黄码,2:红码)")
    @TableField("biz_org_name")
    private  String bizOrgName;

    @ApiModelProperty(value = "状态(0:绿码,1:黄码,2:红码)")
    @TableField("system_code")
    private  String systemCode;

    @ApiModelProperty(value = "状态(0:绿码,1:黄码,2:红码)")
    @TableField("clean_reason")
    private  String cleanReason;

    @ApiModelProperty(value = "装备指标")
    @TableField("equip_index")
    private  String equipIndex;

}
