package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author ZeHua Li
 * @date 2020/12/28 17:43
 * @since v2.0
 */
@Data
@TableName("wl_equipment_system_source_statistics")
@ApiModel(value = "EquipmentSystemSourceStatistics对象", description = "系统区域统计表")
public class EquipmentSystemSourceStatistics extends BaseEntity {

    @ApiModelProperty(value = "设备id")
    @TableField("equipment_specific_id")
    private Long equipmentSpecificId;

    @ApiModelProperty(value = "区域id")
    @TableField("source_id")
    private Long sourceId;

    @ApiModelProperty(value = "系统id")
    @TableField("system_id")
    private Long systemId;

    @ApiModelProperty(value = "状态（1停运 <2运行 <3故障 <4火警）")
    @TableField("status")
    private Integer status;

    @ApiModelProperty(value = "修改时间")
    @TableField("update_time")
    private Date updateTime;

}
