package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

@Data
@Builder
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@TableName("f_fire_fighting_system_group")
@ApiModel(value = "f_fire_fighting_system_group", description = "消防系统分组")
public class FireFightingSystemGroupEntity extends BaseEntity {

    @ApiModelProperty(value = "分组名称")
    private String groupName;

    @ApiModelProperty(value = "分组编码")
    private String groupCode;

    @ApiModelProperty(value = "展示类型：0-系统部件 1-安措")
    private Integer displayType;

    @ApiModelProperty(value = "系统ID")
    private String systemIds;

    @ApiModelProperty(value = "备注")
    private String remarks;

    @ApiModelProperty(value = "分组排序")
    private Integer sort;

    @ApiModelProperty(value = "业务组织编码")
    private String bizOrgCode;

    @ApiModelProperty(value = "业务组织名称")
    private String bizOrgName;
}
