package com.yeejoin.equipmanage.common.entity;


import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.data.annotation.Transient;

import java.util.Map;

/**
 * @author DELL
 */
@Data
@TableName("wl_risk_source_scene")
@EqualsAndHashCode(callSuper = true)
public class RiskSourceScene extends BaseEntity {
    /**
     * 风险id
     */
    @TableField("risk_source_id")
    private Long riskSourceId;
    /**
     * 场景id
     */
    @TableField("scene_id")
    private Long sceneId;
    /**
     * orgCode 冗余
     */
    @TableField("org_code")
    private String orgCode;
    /**
     * 备注
     */
    private String remark;

    @TableField("risk_source_name")
    @ApiModelProperty(value = "风险名称")
    private String riskSourceName;

    @Transient
    @TableField(exist = false)
    private Long subjectId;

    @ApiModelProperty(value = "画布")
    @TableField("content")
    private String content;


    @Transient
    @TableField(exist = false)
    private Map<String,Object> dataConfig;
}
