package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author DELL
 */
@Data
@TableName("wl_source_scene")
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "wl_source_scene", description = "资源与场景关联关系表")
public class SourceScene extends BaseEntity {

    @ApiModelProperty(value = "文件路径")
    @TableField("source_id")
    private Long sourceId;

    @ApiModelProperty(value = "文件名称")
    @TableField("source_name")
    private String sourceName;
    
    @ApiModelProperty(value = "数据源类型：building（建筑类），system（系统类）")
    @TableField("source_type")
    private String sourceType;

    @ApiModelProperty(value = "组态工程id")
    @TableField("project_id")
    private String projectId;

    @ApiModelProperty(value = "组态场景id")
    @TableField("scene_id")
    private Long sceneId;

    @ApiModelProperty(value = "场景包含的点（逗号分割）")
    @TableField("point_in_scene")
    private String pointInScene;

    @ApiModelProperty(value = "视频绑定点（逗号分割）")
    @TableField("video_in_scene")
    private String videoInScene;

    @ApiModelProperty(value = "创建者")
    @TableField(value = "creator_id",fill = FieldFill.INSERT_UPDATE)
    private Long creatorId;

    @ApiModelProperty(value = "创建者")
    @TableField("remark")
    private String remark;

}
