package com.yeejoin.equipmanage.common.entity.dto;

import com.yeejoin.equipmanage.common.entity.EquipmentSpecific;
import com.yeejoin.equipmanage.common.entity.publics.BaseDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author ZeHua Li
 * @date 2020/12/18 14:56
 * @since v2.0
 */
@Data
public class EquipTypeAmountPageDTO extends BaseDTO<EquipmentSpecific> {

    @ApiModelProperty(value = "分类编码")
    private String equipmentClassificationCode;

    @ApiModelProperty(value = "设备编码")
    private String code;

    @ApiModelProperty(value = "物联编码")
    private String iotCode;

    @ApiModelProperty(value = "系统id")
    private Long systemId;

    @ApiModelProperty(value = "生产厂家id")
    private Long manufacturerId;

    @ApiModelProperty(value = "设备名称")
    private String equipmentName;

    @ApiModelProperty(value = "进口/国产")
    private Integer isImport;

    @ApiModelProperty(value = "入库状态 1 入库 0未入库 不传全部")
    private Integer status;

    @ApiModelProperty(value = "类型 car：车辆，equipment：设备")
    private String type;

    @ApiModelProperty(value = "所在位置")
    private Long warehouseStructureId;

    @ApiModelProperty(value = "行业编码")
    private String industryCode;
    
    @ApiModelProperty(value = "所在位置名称")
    private String warehouseStructureName;

    @ApiModelProperty(value = "单位部门名陈")
    private String bizOrgName;
    @ApiModelProperty(value = "单位部门org")
    private String bizOrgCode;

    @ApiModelProperty(value = "队伍id")
    private String teamId;

    @ApiModelProperty(value = "是否物联")
    private String isIot;

    @ApiModelProperty(value = "装备编码或名称")
    private String nameOrCode;

    @ApiModelProperty(value = "缺陷管理新增页面用，其余地方可忽略 1-是缺陷管理 0-不是")
    private Integer isDefect;

    @ApiModelProperty(value = "关键字-地图用")
    private String keyword;

    @ApiModelProperty(value = "页数-地图用")
    private Integer current;

    @ApiModelProperty(value = "分页大小-地图用")
    private Integer size;

    @ApiModelProperty(value = "车牌号")
    private String carNum;

    @ApiModelProperty(value = "设备红黄绿码状态")
    private String equipStatus;

    @ApiModelProperty(value = "概览装备分类")
    private String equipCodeKey;

    @ApiModelProperty(value = "设备3.0--查询器材装备列表，1-统计六类设备")
    private String sixEquipType;
}
