package com.yeejoin.equipmanage.common.entity.vo;

import com.yeejoin.equipmanage.common.entity.Video;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author ZeHua Li
 * @date 2020/11/16 16:41
 * @since v2.0
 * 风险树返回实体
 * 属性对应 f_risk_source 表
 */
@Data
public class RiskSourceTreeVO extends Video {
    /**
     * 父级id
     */
    private Long parentId;
    /**
     * 风险等级id
     */
    private Long riskLevelId;

    private String code;

    private String name;

    private String level;

    private BigDecimal rpn;

    private BigDecimal rpni;

    private String isRegion;

    private Integer isIndoor;

    private String position3d;

    private String floor3d;

    private String status;

    private Integer count;

    private Integer qualified;
    private Integer unqualified;
    private Integer omission;
    private Integer unplan;

    private Long value;
    private Long pId;
    private String title;
    private String lable;
    private String riskSourceType;

    private Integer sceneId;


    private List<RiskSourceTreeVO> children;
}
