package com.yeejoin.equipmanage.common.enums;

/**
 * 赋码计算规则
 * @author DELL
 */

public enum CalculationRulesEnum {
    EQ("eq", "等于"),
    NE("ne", "不等于"),
    GT("gt", "大于"),
    GE("ge", "大于等于"),
    LT("lt", "小于"),
    LE("le", "小于等于"),
    BE("be", "介于两者之间");

    private String code;
    private String type;

    CalculationRulesEnum(String code, String type) {
        this.code=code;
        this.type=type;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public static CalculationRulesEnum getEnum(String code) {
        CalculationRulesEnum calculationRulesEnum = null;
        for(CalculationRulesEnum type: CalculationRulesEnum.values()) {
            if (type.getCode().equals(code)) {
                calculationRulesEnum = type;
                break;
            }
        }
        return calculationRulesEnum;
    }

}
