package com.yeejoin.equipmanage.common.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author
 * @title: EquipQrcodeColorEnum
 * <pre>
 * @description: TODO
 * </pre>
 * @date 2020/12/12 14:23
 */
@Getter
@AllArgsConstructor
public enum DynamicLabelEnum {

    NAME("name","名称"),
    CODE("code","编码"),
    POSITION("position","存放位置"),
    MANUFACTURER("manufacturer","供应商"),
    SYSTEM("systemName","所属系统"),
    QRCODE("qrCode", "二维码"),
    ALARMCONTENT("alarmContent","告警内容"),
    ALARMDATE("alarmDate","告警时间");

    private String code;

    private String describe;

    public static DynamicLabelEnum getEnumByKey(String key) {
        DynamicLabelEnum colorEnum = null;
        for (DynamicLabelEnum u : DynamicLabelEnum.values()) {
            if (u.getCode().equals(key)) {
                colorEnum = u;
                break;
            }
        }
        return colorEnum;
    }

}
