package com.yeejoin.equipmanage.common.enums;


import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

public enum PressurePumpEnum {

    ALONE_START_YXSC("FHS_PressurePump_Start_ALONE_START_YXSC", "", LocalDateTime.now().getSecond() + " " + (LocalDateTime.now().getMinute()) + "/5 * * * ?", "5",
            PressurePumpValueEnum.PUMP_START_TIME.getCode(), PressurePumpMessageEnum.MESSAGE_LEVEL_QT_WJ_YXSC.getCode(), "【5】分钟"),

    ALONE_START_QT("FHS_PressurePump_Start_ALONE_START_QT", PressurePumpCheckEnum.BE.getCode(), "0", "5",
            PressurePumpValueEnum.LAST_START.getCode(), PressurePumpMessageEnum.MESSAGE_LEVEL_QT_WJ.getCode(), "【5】分钟"),

    ALONE_START_QT_WJ("FHS_PressurePump_Start_ALONE_START_QT_WJ", PressurePumpCheckEnum.BE.getCode(), "5", "30",
            PressurePumpValueEnum.LAST_START.getCode(), PressurePumpMessageEnum.MESSAGE_LEVEL_QT_WJ.getCode(), "【30】分钟"),

    ALONE_START_QT_YZ("FHS_PressurePump_Start_ALONE_START_QT_YZ", PressurePumpCheckEnum.BE.getCode(), "30", "60",
            PressurePumpValueEnum.LAST_START.getCode(), PressurePumpMessageEnum.MESSAGE_LEVEL_YZ.getCode(), "【1】小时"),

    ALL_START_QT_WJ("FHS_PressurePump_Start_ALL_START_QT_WJ", PressurePumpCheckEnum.BE.getCode(), "0", "5",
            PressurePumpValueEnum.LATELY_START.getCode(), PressurePumpMessageEnum.MESSAGE_LEVEL_QT_WJ.getCode(), "【5】分钟"),

    START_QT_WJ_ALL("FHS_PressurePump_Start_ALL_START_QT_YZ", PressurePumpCheckEnum.BE.getCode(), "5", "30",
            PressurePumpValueEnum.LATELY_START.getCode(), PressurePumpMessageEnum.MESSAGE_LEVEL_QT_WJ.getCode(), "【30】分钟"),

    ALL_STOP_QT_YZ("FHS_PressurePump_Start_ALL_STOP_QT_YZ", PressurePumpCheckEnum.BE.getCode(), "30", "60",
            PressurePumpValueEnum.LATELY_START.getCode(), PressurePumpMessageEnum.MESSAGE_LEVEL_YZ.getCode(), "【1】小时");

    // 备份2023-07-13
//    ALONE_START_YXSC("FHS_PressurePump_Start_ALONE_START_YXSC", "", LocalDateTime.now().getSecond() + " " + (LocalDateTime.now().getMinute()) + "/5 * * * ?", "5",
//            PressurePumpValueEnum.PUMP_START_TIME.getCode(), PressurePumpMessageEnum.MESSAGE_LEVEL_QT_WJ_YXSC.getCode(), "【5】分钟"),
//
//    ALONE_START_QT("FHS_PressurePump_Start_ALONE_START_QT", PressurePumpCheckEnum.LE.getCode(), "", "5",
//            PressurePumpValueEnum.LAST_STOP.getCode(), PressurePumpMessageEnum.MESSAGE_LEVEL_QT_WJ.getCode(), "【5】分钟"),
//
//    ALONE_STOP_QT("FHS_PressurePump_Stop_ALONE_STOP_QT", PressurePumpCheckEnum.GE.getCode(), "5", "",
//            PressurePumpValueEnum.LAST_START.getCode(), PressurePumpMessageEnum.MESSAGE_LEVEL_QT_WJ_YXSC.getCode(), "【5】分钟"),
//
//    ALL_START_QT_WJ("FHS_PressurePump_Start_ALL_START_QT_WJ", PressurePumpCheckEnum.LE.getCode(), "", "30",
//            PressurePumpValueEnum.LATELY_STOP.getCode(), PressurePumpMessageEnum.MESSAGE_LEVEL_QT_WJ.getCode(), "【30】分钟"),
//
//    ALL_START_QT_YZ("FHS_PressurePump_Start_ALL_START_QT_YZ", PressurePumpCheckEnum.BE.getCode(), "30", "60",
//            PressurePumpValueEnum.LATELY_STOP.getCode(), PressurePumpMessageEnum.MESSAGE_LEVEL_YZ.getCode(), "【1】小时"),
//
//    ALL_START_QT_YB("FHS_PressurePump_Start_ALL_START_QT_YB", PressurePumpCheckEnum.BE.getCode(), "60", "240",
//            PressurePumpValueEnum.LATELY_STOP.getCode(), PressurePumpMessageEnum.MESSAGE_LEVEL_YB.getCode(), "【4】小时"),
//
//    ALL_STOP_QT_WJ("FHS_PressurePump_Stop_ALL_STOP_QT_WJ", PressurePumpCheckEnum.LE.getCode(), "", "30",
//            PressurePumpValueEnum.LATELY_START.getCode(), PressurePumpMessageEnum.MESSAGE_LEVEL_QT_WJ.getCode(), "【30】分钟"),
//
//    ALL_STOP_QT_YZ("FHS_PressurePump_Stop_ALL_STOP_QT_YZ", PressurePumpCheckEnum.BE.getCode(), "30", "60",
//            PressurePumpValueEnum.LATELY_START.getCode(), PressurePumpMessageEnum.MESSAGE_LEVEL_YZ.getCode(), "【1】小时"),
//
//    ALL_STOP_QT_YB("FHS_PressurePump_Stop_ALL_STOP_QT_YB", PressurePumpCheckEnum.BE.getCode(), "60", "240",
//            PressurePumpValueEnum.LATELY_START.getCode(), PressurePumpMessageEnum.MESSAGE_LEVEL_YB.getCode(), "【4】小时");

    private String code;
    private String operator;
    private String leftValue;
    private String rightValue;
    private String compareValue;
    private String level;
    private String tips;

    PressurePumpEnum(String code, String operator, String leftValue, String rightValue, String compareValue, String level, String tips) {
        this.code = code;
        this.operator = operator;
        this.leftValue = leftValue;
        this.rightValue = rightValue;
        this.compareValue = compareValue;
        this.level = level;
        this.tips = tips;
    }

    public static List<PressurePumpEnum> getEnumListByCode(String value) {
        List<PressurePumpEnum> list = new ArrayList<>();
        for(PressurePumpEnum e : PressurePumpEnum.values()) {
            if (value.equals("false")) {
                if (e.getCode().startsWith("FHS_PressurePump_Stop")) {
                    list.add(e);
                }
            } else {
                if (e.getCode().startsWith("FHS_PressurePump_Start")) {
                    list.add(e);
                }
            }
        }
        return list;
    }

    public String getCode() {
        return code;
    }
    public String getOperator() {
        return operator;
    }
    public String getLeftValue() {
        return leftValue;
    }
    public String getRightValue() {
        return rightValue;
    }
    public String getCompareValue() { return compareValue; }
    public String getLevel() { return level; }
    public String getTips() { return tips; }
}
