package com.yeejoin.equipmanage.common.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

@Getter
@AllArgsConstructor
public enum SystemGroupShowTypeEnum {

    SYSTEM_EQUIPMENT(0, "系统部件"),
    SECURITY_MEASURE(1, "安措");

    private final Integer code;

    private final String value;

    public static SystemGroupShowTypeEnum getEnumByCode(Integer code) {
        SystemGroupShowTypeEnum aEnum = null;
        for (SystemGroupShowTypeEnum item : SystemGroupShowTypeEnum.values()) {
            if (Objects.equals(item.getCode(), code)) {
                aEnum = item;
                break;
            }
        }
        return aEnum;
    }
}
