package com.yeejoin.amos.fas.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 *0、运行中，1、完毕，3、中断
 *  @author suhg
 */

public enum PlanRecordStatusEnum {
    OPERATION("运行中",0),
    COMPLETE("完毕",1),
    INTERRUPT("中断",2);

    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private Integer code;

    /**
     * 颜色
     */
    private String color;


    private PlanRecordStatusEnum(String name, Integer code){
        this.name = name;
        this.code = code;
    }

    public static PlanRecordStatusEnum getEnum(Integer code) {
        PlanRecordStatusEnum checkStatusEnum = null;
        for(PlanRecordStatusEnum type: PlanRecordStatusEnum.values()) {
            if (type.getCode().equals(code)) {
                checkStatusEnum = type;
                break;
            }
        }

        return checkStatusEnum;
    }

    public static List<Map<String,Object>> getEnumList() {
        List<Map<String,Object>> nameList = new ArrayList<>();
        for (PlanRecordStatusEnum c: PlanRecordStatusEnum.values()) {
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("name", c.getName());
            map.put("code", c.getCode());
            nameList.add(map);
        }
        return nameList;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }
}

