package com.yeejoin.amos.fas.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum RiskSourceLevelEum {
	/**
	 * 风险等级 名称 安全提示
	 */
	level_1("1","1级", "警告"),
	level_2("2","2级","注意"),
	level_3("3","3级","安全"),
	level_4("4","4级","安全"),
	level_5("5","5级","安全");
	
	private String level;
	private String name;
	private String tips;


	RiskSourceLevelEum(String level, String name, String tips) {
		this.level = level;
		this.name = name;
		this.tips = tips;
	}

	public static String getTipsByLevel(String level){
		String tips = null;
		for (RiskSourceLevelEum eum: RiskSourceLevelEum.values()){
			if(eum.getLevel().equals(level) ){
				tips = eum.getTips();
				break;
			}
		}
		return tips;
	}

	public String getLevel() {
		return level;
	}

	public void setLevel(String level) {
		this.level = level;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	public static List<Map<String,String>> getLevelEnumList() {
		List<Map<String,String>> nameList = new ArrayList<>();
		for (RiskSourceLevelEum c: RiskSourceLevelEum.values()) {
			Map<String, String> map = new HashMap<String, String>();
			map.put("name", c.getName());
			map.put("level", c.getLevel());
			nameList.add(map);
		}
		return nameList;
	}

	public String getTips() {
		return tips;
	}

	public void setTips(String tips) {
		this.tips = tips;
	}
	
	
}
