package com.yeejoin.amos.fas.dao.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;


/**
 * The persistent class for the risk_source database table.
 * 
 */
@Entity
@Table(name="p_point")
@NamedQuery(name="PPoint.findAll", query="SELECT r FROM PPoint r")
public class PPoint extends BasicEntity  {
	private static final long serialVersionUID = 1L;

	@Column(name="route_id")
	 private String   routeId  ;// '路线id',

	@Column(name="route_name")
	 private String   routeName  ;// '路线名称',

	@Column(name="name")
	 private String   name  ;// '点名称',

	@Column(name="point_no")
	 private String   pointNo  ;// '点编号',

	@Column(name="remark")
	 private String   remark ;// '备注说明',

	@Column(name="save_gps")
	 private String   saveGps  ;// '是否保存地理信',

	@Column(name="distance")
	 private Integer   distance  ;// '有效巡检距离',

	@Column(name="usually_shot")
	 private String   usuallyShot  ;// '是否允许普通拍照',

	@Column(name="shot_min_number")
	 private Integer   shotMinNumber  ;// '最小拍照数',

	@Column(name="shot_max_number")
	 private Integer   shotMaxNumber  ;// '最大拍照数',

	@Column(name="fixed_shot")
	 private Integer   fixedShot  ;//'定点拍照数',

	@Column(name="latitude")
	 private String   latitude  ;//T '经度',

	@Column(name="longitude")
	 private String   longitude  ;// '纬度',

	@Column(name="address")
	 private String   address ;//'参考地址',

	@Column(name="offline")
	 private Boolean   offline ;// '是否允许离线巡检:0不支持1支持',

	@Column(name="is_fixed")
	 private String   isFixed ;// '是否为固定',

	@Column(name="catalog_id")
	 private Integer   catalogId  ;//'分类编号',

	@Column(name="extend_json")
	 private String   extendJson  ;// '扩展字段',

	@Column(name="is_score")
	 private String   isScore  ;// '无计划巡检是否评分',

	@Column(name="level")
	 private String   level ;// '风险等级',

	@Column(name="last_update_time")
	 private String   lastUpdateTime ;// '最新更新时间',

	@Column(name="creator_id")
	 private Long    creatorId  ;//'创建用户id',

	@Column(name="org_code")
	 private String   orgCode  ;// '权限系统org code',

	@Column(name="coordinates")
	 private String   coordinates  ;// '3维坐标',

	@Column(name="is_delete")
	 private Boolean   isDelete  ;// '是否删除：0表示未删除，1表示已删除',

	@Column(name="charge_dept_id")
	 private String   chargeDeptId ;// '责任部门id',

	@Column(name="charge_person_id")
	 private String   chargePersonId  ;// '负责人id',

	@Column(name="status")
	 private String   status  ;// '状态：0 未纳入巡检，1 合格；2 不合格；3 漏检',

	@Column(name="floor")
	 private Integer   floor ;// '3维模型楼层',

	@Column(name="error")
	 private String   error  ;// '最新不合格信息',

	@Column(name="check_time")
	 private String   checkTime  ;//'最新检查时间',


	public String getRouteId() {
		return routeId;
	}

	public void setRouteId(String routeId) {
		this.routeId = routeId;
	}

	public String getRouteName() {
		return routeName;
	}

	public void setRouteName(String routeName) {
		this.routeName = routeName;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getPointNo() {
		return pointNo;
	}

	public void setPointNo(String pointNo) {
		this.pointNo = pointNo;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public String getSaveGps() {
		return saveGps;
	}

	public void setSaveGps(String saveGps) {
		this.saveGps = saveGps;
	}

	public Integer getDistance() {
		return distance;
	}

	public void setDistance(Integer distance) {
		this.distance = distance;
	}

	public String getUsuallyShot() {
		return usuallyShot;
	}

	public void setUsuallyShot(String usuallyShot) {
		this.usuallyShot = usuallyShot;
	}

	public Integer getShotMinNumber() {
		return shotMinNumber;
	}

	public void setShotMinNumber(Integer shotMinNumber) {
		this.shotMinNumber = shotMinNumber;
	}

	public Integer getShotMaxNumber() {
		return shotMaxNumber;
	}

	public void setShotMaxNumber(Integer shotMaxNumber) {
		this.shotMaxNumber = shotMaxNumber;
	}

	public Integer getFixedShot() {
		return fixedShot;
	}

	public void setFixedShot(Integer fixedShot) {
		this.fixedShot = fixedShot;
	}

	public String getLatitude() {
		return latitude;
	}

	public void setLatitude(String latitude) {
		this.latitude = latitude;
	}

	public String getLongitude() {
		return longitude;
	}

	public void setLongitude(String longitude) {
		this.longitude = longitude;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public Boolean getOffline() {
		return offline;
	}

	public void setOffline(Boolean offline) {
		this.offline = offline;
	}

	public String getIsFixed() {
		return isFixed;
	}

	public void setIsFixed(String isFixed) {
		this.isFixed = isFixed;
	}

	public Integer getCatalogId() {
		return catalogId;
	}

	public void setCatalogId(Integer catalogId) {
		this.catalogId = catalogId;
	}

	public String getExtendJson() {
		return extendJson;
	}

	public void setExtendJson(String extendJson) {
		this.extendJson = extendJson;
	}

	public String getIsScore() {
		return isScore;
	}

	public void setIsScore(String isScore) {
		this.isScore = isScore;
	}

	public String getLevel() {
		return level;
	}

	public void setLevel(String level) {
		this.level = level;
	}

	public String getLastUpdateTime() {
		return lastUpdateTime;
	}

	public void setLastUpdateTime(String lastUpdateTime) {
		this.lastUpdateTime = lastUpdateTime;
	}

	public Long getCreatorId() {
		return creatorId;
	}

	public void setCreatorId(Long creatorId) {
		this.creatorId = creatorId;
	}

	public String getOrgCode() {
		return orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public String getCoordinates() {
		return coordinates;
	}

	public void setCoordinates(String coordinates) {
		this.coordinates = coordinates;
	}

	public Boolean getIsDelete() {
		return isDelete;
	}

	public void setIsDelete(Boolean delete) {
		isDelete = delete;
	}

	public String getChargeDeptId() {
		return chargeDeptId;
	}

	public void setChargeDeptId(String chargeDeptId) {
		this.chargeDeptId = chargeDeptId;
	}

	public String getChargePersonId() {
		return chargePersonId;
	}

	public void setChargePersonId(String chargePersonId) {
		this.chargePersonId = chargePersonId;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public Integer getFloor() {
		return floor;
	}

	public void setFloor(Integer floor) {
		this.floor = floor;
	}

	public String getError() {
		return error;
	}

	public void setError(String error) {
		this.error = error;
	}

	public String getCheckTime() {
		return checkTime;
	}

	public void setCheckTime(String checkTime) {
		this.checkTime = checkTime;
	}
}