package com.yeejoin.amos.boot.module.jcs.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 力量调派发送信息记录表
 *
 * @author litw
 * @date 2021-11-05
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="PowerrTransferLogDto", description="力量调派发送信息记录表")
public class PowerrTransferLogDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "队伍id")
    private Long teamId;

    @ApiModelProperty(value = "资源id(目前只有车辆)")
    private Long resourceId;

    @ApiModelProperty(value = "接收人")
    private String receiveName;

    @ApiModelProperty(value = "发送时间")
    private String sendTime;

    @ApiModelProperty(value = "发送内容")
    private String sendContent;

   @ApiModelProperty(value = "调派类型(0，队伍，1，资源)")
   private String type;

}
