package com.yeejoin.amos.boot.module.jcs.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * <pre>
 * 联动控制器大队枚举
 * </pre>
 *
 * @author gwb
 * @version $Id: ControllerTypeEnum.java, v 0.1 2021年8月20日 上午10:21:44 gwb Exp $
 */
@AllArgsConstructor
@Getter
public enum ControllerGroupEnum {
    ONE("一大队", 1, 1), TWO("二大队", 3, 2), THREE("三大队", 2, 3);
    private final String name;
    private final int type;
    private final int order;

    public static ControllerGroupEnum getEnum(int type) {
        for (ControllerGroupEnum status : ControllerGroupEnum.values()) {
            if (status.getType() == type) {
                return status;
            }
        }
        return null;
    }
}
