package com.yeejoin.amos.boot.module.jcs.api.enums;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.List;
import java.util.Map;

/**
 * @author DELL
 */
@Getter
@AllArgsConstructor
public enum FireCarStatusEnum {
    执勤("ZW","1", "执勤"),
    出动("ZQ","2", "出动"),
    途中("TZ","3", "途中"),
	到场("DC","4", "到场"),
	出水("CS","5", "出水"),
	停水("TS","6", "停水"),
	驻防("ZF","7", "驻防"),
	返队("FD","8", "返队"),
	训练("XL","9", "训练"),
	演练("YL","10", "演练"),
	加油("JY","11", "加油"),
	试车("SC","12", "试车"),


    执行中("ZXZ","executing", "执行中"),
    已完成("YWC","finished", "已完成");





    private String key;
    private String code;
    private String name;

    public static FireCarStatusEnum getEnum(String code) {
        for (FireCarStatusEnum status : FireCarStatusEnum.values()) {
            if (status.getCode().equals(code)) {
                return status;
            }
        }
        return null;
    }

    /**
     * 枚举转列表
     *
     * @return
     */
    public static List<Map<String, String>> toList() {
        List<Map<String, String>> enumList = Lists.newArrayList();
        for (FireCarStatusEnum item : FireCarStatusEnum.values()) {
            Map<String, String> map = Maps.newHashMap();
            map.put("key", item.getCode());
            map.put("label", item.getName());
            enumList.add(map);
        }
        return enumList;
    }
}
