package com.yeejoin.amos.knowledgebase.face.orm.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

/**
 * <p>
 * 标签库
 * </p>
 *
 * @author 子杨
 * @since 2020-08-05
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("knowledge_tag")
public class KnowledgeTag extends BaseEntity {


	/**
	 * 标签名称
	 */
	@TableField("TAG_NAME")
	private String tagName;
	/**
	 * 标签编码
	 */
	@TableField("TAG_CODE")
	private String tagCode;

	/**
	 * 标签分类：文本标签，值标签，
	 */
	@TableField("TAG_TYPE")
	private String tagType;
	/**
	 * 标签状态：启用，禁用
	 */
	@TableField("TAG_STATUS")
	private String tagStatus;
	/**
	 * 标签备注
	 */
	@TableField("TAG_REMARK")
	private String tagRemark;
	/**
	 * 机构编号
	 */
	@TableField("AGENCY_CODE")
	private String agencyCode;

	/**
	 * 创建人姓名
	 */
	@TableField("CREATOR")
	private String creator;
}

