package com.yeejoin.amos.latentdanger.common.enums;

public enum WorkFlowUriEnum {

    启动流程("启动流程", "/workflow/task/startTask", ""),
    流程详情("流程详情", "/workflow/task/{taskId}", "taskId"),
    合并启动流程("合并启动流程", "/workflow/task/startProcess", ""),
    所有已执行任务详情("所有已执行任务详情","/workflow/activitiHistory/task/detail/{taskId}","taskId"),
    流程任务("流程任务", "/workflow/task?processInstanceId={processInstanceId}", "processInstanceId"),
    我的代办("我的代办", "/workflow/task/all-list?processDefinitionKey={processDefinitionKey}", "processDefinitionKey"),
    我的代办有ID("我的代办有ID", "/workflow/task/all-list?processDefinitionKey={processDefinitionKey}&userId={userId}", "processDefinitionKey,userId"),
    已执行任务("已执行任务", "/workflow/activitiHistory/all-historytasks?processDefinitionKey={processDefinitionKey}", "processDefinitionKey"),
    已执行任务有ID("已执行任务有ID", "/workflow/activitiHistory/all-historytasks?processDefinitionKey={processDefinitionKey}&userId={userId}", "processDefinitionKey,userId"),
    启动免登录流程("启动免登录流程", "/processes/{appKey}", "appKey"),
    当前节点("当前节点", "/wf/taskstodo?processInstanceId={processInstanceId}", "processInstanceId"),
    执行流程("执行流程", "/workflow/task/pickupAndCompleteTask/{taskId}", "taskId"),
    终止流程("终止流程", "/wf/processes/{processInstanceId}?deleteReason={deleteReason}", "processInstanceId,deleteReason"),
    当前子节点("当前子节点", "/wf/processes/{processInstanceId}/tasks?taskDefinitionKey={taskDefinitionKey}", "processInstanceId,taskDefinitionKey"),
    工作流流水("工作流流水","/wf/processes/{processInstanceId}/tasks", "processInstanceId"),
    子节点信息("子节点信息","/workflow/task/list/all/{instanceId}", "instanceId");

    private String desc;

    private String uri;

    private String params;

    WorkFlowUriEnum(String desc, String uri, String params) {
        this.desc = desc;
        this.uri = uri;
        this.params = params;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getUri() {
        return uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getParams() {
        return params;
    }

    public void setParams(String params) {
        this.params = params;
    }
}
