package com.yeejoin.amos.maintenance.common.enums;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import java.util.List;
import java.util.Map;

public enum MsgSubscribeEnum {

    计划开始前推送("planBeginApp", "计划开始", "检查计划开始前{attribute2}分钟，推送消息提醒", true, "plan"),
    计划开始后推送("planWarnApp", "计划提醒", "检查计划已开始{attribute2}分钟还未开始检查，推送消息提醒", true, "plan"),
    计划漏检推送("planEndApp", "漏检提醒", "检查计划后{attribute2}分钟有漏检点，推送消息提醒", true, "plan"),
    风险研判推送("riskJudgmentApp", "风险研判", "风险研判移动端推送", false, "default"),
    作业活动推送("taskworkApp", "作业活动", "作业活动移动端推送", false, "default"),
    通知公告推送("notifyApp", "通知公告", "通知公告推送", false, "default"),
    有检查记录推送("checkRecordPushHavaRecordApp", "检查记录", "有检查记录推送", true, "check"),
    有不合格记录推送("checkRecordHavaNoPassRecordApp", "不合格记录", "有不合格记录推送", true, "check"),
    有漏检推送("checkRecordHaveMissRecordApp", "漏检记录", "有漏检才推送", true, "check"),
    全部不推送("checkRecordNoPushApp", "全部不推送", "全部不推送", true, "check"),
    隐患治理推送("latentDangerApp", "隐患治理", "隐患治理移动端推送", false, "default"),
    风险评价提醒推送("riskFatorApp", "风险评价提醒", "风险评价提醒", false, "default"),
    推送检查计划消息("planEmail", "检查计划", "推送检查计划消息", true, "email"),
    推送检查记录消息("checkRecordEmail", "检查记录", "推送检查记录消息", true, "email"),
    推送风险研判消息("riskJudgmentEmail", "风险研判", "推送风险研判消息", true, "email"),
    推送作业活动消息("taskworkEmail", "作业活动", "推送作业活动消息", true, "email");

    MsgSubscribeEnum(String msgType, String title, String desc, Boolean canConfig, String type) {
        this.msgType = msgType;
        this.title = title;
        this.desc = desc;
        this.canConfig = canConfig;
        this.type = type;
    }

    private String msgType;

    private String title;

    private String desc;

    private Boolean canConfig;

    private String type;

    public String getMsgType() {
        return msgType;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Boolean getCanConfig() {
        return canConfig;
    }

    public void setCanConfig(Boolean canConfig) {
        this.canConfig = canConfig;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public static List<Map<String, String>> getEnumList() {
        List<Map<String, String>> list = Lists.newArrayList();
        for (MsgSubscribeEnum e : MsgSubscribeEnum.values()) {
            if (e.canConfig && !e.getMsgType().equals("checkRecordNoPushApp") && !e.getType().equals("email")) {
                Map<String, String> msgType = Maps.newHashMap();
                msgType.put(e.getMsgType(), e.getTitle());
                list.add(msgType);
            }
        }
        return list;
    }

    public static MsgSubscribeEnum getByMsgType(String msgType) {
        for (MsgSubscribeEnum typeEnum : MsgSubscribeEnum.values()) {
            if (msgType.equals(typeEnum.msgType)) {
                return typeEnum;
            }
        }
        return null;
    }
}
