package com.yeejoin.amos.maintenance.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum TaskFeedbackType {
	FEEDBACK("已回复","feedback"),
	FINISH("已完成","finish"),
	CANCAL("已取消","cancal"),
	FORWARD("已转发","forward"),
	TIMEOUT("已超时","timeout");
	
	/**
	 * 名称，描述
	 */
	private String name;
	/**
	 * 编码
	 */
	private String code;
	
	private TaskFeedbackType(String name,String code){
		this.name = name;
		this.code = code;
	}
	
	public static TaskFeedbackType getEnum(String code) {
		TaskFeedbackType TaskFeedbackType = null;
		for(TaskFeedbackType type: TaskFeedbackType.values()) {
			if (type.getCode().equals(code)) {
				TaskFeedbackType = type;
				break;
			}
		}
		
		return TaskFeedbackType;
	}
	
	public static List<Map<String,String>> getEnumList() {
		List<Map<String,String>> list = new ArrayList<>();
		for(TaskFeedbackType e : TaskFeedbackType.values()) {
			Map<String,String> msgType = new HashMap<>();
			msgType.put(e.getCode(),e.getName());
			list.add(msgType);
		}
		return list;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}
}
