package com.yeejoin.precontrol.common.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 用户app菜单配置表
 *
 * @author duanwei
 * @date 2021-02-22
 */
@Data
@ApiModel(value = "AppMenuConfigDto", description = "用户app菜单配置表")
public class AppMenuConfigDto {


    private Long id;

    @ApiModelProperty(value = "创建时间")
    private Date createDate;

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "用户id")
    private String userId;

    @ApiModelProperty(value = "菜单key")
    private String menuKey;

    @ApiModelProperty(value = "菜单描述")
    private String menuLabel;

    @ApiModelProperty(value = "图标")
    private String menuIcon;

    @ApiModelProperty(value = "排序")
    private Integer sort;

    @ApiModelProperty(value = "是否必须", notes = "初始化的前4个不可删除,子定义的可删除")
    private Boolean isMust;
}
