package com.yeejoin.precontrol.common.dto;

import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import com.yeejoin.precontrol.common.entity.HazardousWorkResult;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 三交三查
 *
 * @author duanwei
 * @date 2020-07-01
 */
@Data
public class TaskPaycheckDto extends BaseDto{
    @ApiModelProperty(value = "施工任务")
    private Long constructionTask;
    @ApiModelProperty(value = "技术要求")
    private Long technicalRequire;
    @ApiModelProperty(value = "安全环保措施")
    private Long environmentProtect;
    @ApiModelProperty(value = "着装")
    private Long dress;
    @ApiModelProperty(value = "三宝(安全帽、安全带、安全鞋)")
    private Long saftTreasure;
    @ApiModelProperty(value = "精神状态")
    private Long mentalState;
    @ApiModelProperty(value = "是否风险作业")
    private Long riskOperation;
    @ApiModelProperty(value = "风险作业类型ID")
    private Long riskTypeId;
    @ApiModelProperty(value = "风险作业类型")
    private String riskType;
    @ApiModelProperty(value = "人员类型")
    private List<TaskPersonDto> taskPerson;
    @ApiModelProperty(value = "天气")
    private String weatherName;
    @ApiModelProperty(value = "作业票名称")
    private String workTicketName;
    @ApiModelProperty(value = "作业票图片")
    @ImagePrefix
    private List<String> workTicketFilePath;
    @ApiModelProperty(value = "检查项目")
    private List<HazardousWorkResult> hazardousWorkResultList;
    @ApiModelProperty(value = "附件图片")
    @ImagePrefix
    private List<String> attachment;
}
