package com.yeejoin.precontrol.common.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import com.yeejoin.precontrol.common.entity.TaskSalaryConfirmAttachment;
import com.yeejoin.precontrol.common.vo.PersonSalaryExcelVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 薪资确认任务表Dto
 *
 * @author duanwei
 * @date 2020-12-08
 */
@Data
public class TaskSalaryConfirmDto extends BaseDto implements Serializable {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "任务id")
	/**
	 * 任务id
	 */
	private Long taskId;
	@ApiModelProperty(value = "项目id")
	/**
	 * 项目id
	 */
	private Long projectId;
	@ApiModelProperty(value = "项目名称")
	/**
	 * 项目名称
	 */
	private String projectName;
	@ApiModelProperty(value = "分包商id")
	/**
	 * 分包商id
	 */
	private Long companyId;
	@ApiModelProperty(value = "分包商名称")
	/**
	 * 分包商名称
	 */
	private String companyName;
	@ApiModelProperty(value = "合同工资总额")
	/**
	 * 合同工资总额
	 */
	private BigDecimal contractTotalSalary;
	@ApiModelProperty(value = "本次发放金额")
	/**
	 * 本次发放金额
	 */
	private BigDecimal currentPaySalary;
	@ApiModelProperty(value = "付款批次")
	/**
	 * 付款批次
	 */
	private String payBatch;
	@ApiModelProperty(value = "银行账户")
	/**
	 * 银行账户
	 */
	private String bankAccount;
	@ApiModelProperty(value = "付款开始时间")
	/**
	 * 付款开始时间
	 */
	@JsonFormat(pattern="yyyy-MM-dd")
	@DateTimeFormat(pattern="yyyy-MM-dd")
	private Date payStartTime;
	@ApiModelProperty(value = "付款结束时间")
	/**
	 * 付款结束时间
	 */
	@JsonFormat(pattern="yyyy-MM-dd")
	@DateTimeFormat(pattern="yyyy-MM-dd")
	private Date payEndTime;
	@ApiModelProperty(value = "发放类型")
	/**
	 * 发放类型
	 */
	private String payType;
	@ApiModelProperty(value = "发放日期")
	/**
	 * 发放日期
	 */
	@JsonFormat(pattern="yyyy-MM-dd")
	private Date payDate;
	@ApiModelProperty(value = "本次发放比例")
	/**
	 * 本次发放比例
	 */
	private Integer payRatio;
	
	@ApiModelProperty(value = "状态")
	/**
	 * 本次发放比例
	 */
	private Integer status;
	
	/**
	 * 附件列表
	 */
    @ApiModelProperty(value = "附件")
    @ImagePrefix
    private List<TaskSalaryConfirmAttachment> attachment;
	
	/**
	 * 人员列表
	 */
	private List<PersonSalaryExcelVo> taskPersonList;
	
	@ApiModelProperty(value = "创建时间")
	private String createDate;
}
