package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * @Description: 小程序应用
 * @Date: 2021/3/23 17:46
 * @Version: 1.0
 */
@Data
@Accessors(chain = true)
@TableName("rpm_app_menu")
@ApiModel(value = "AppMenu对象", description = "app菜单")
public class AppMenu extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "菜单key")
    private String menuKey;

    @ApiModelProperty(value = "菜单描述")
    private String menuLabel;

    @ApiModelProperty(value = "图标")
    private String menuIcon;
    @ApiModelProperty(value = "跳转页面url",notes = "跳转页面url")
    private String page;
}
