package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Objects;

/**
 * 用户app菜单配置表
 *
 * @author duanwei
 * @date 2021-02-22
 */
@Data
@Accessors(chain = true)
@TableName("rpm_app_menu_config")
@ApiModel(value = "AppMenuConfig对象", description = "用户app菜单配置表")
public class AppMenuConfig extends BaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "用户id")
    private String userId;

    @ApiModelProperty(value = "菜单key")
    private String menuKey;

    @ApiModelProperty(value = "菜单描述")
    private String menuLabel;

    @ApiModelProperty(value = "图标")
    private String menuIcon;

    @ApiModelProperty(value = "排序")
    private Integer sort;

    @ApiModelProperty(value = "是否必须",notes = "初始化的前4个不可删除,子定义的可删除")
    private Boolean isMust;

    @ApiModelProperty(value = "跳转页面url",notes = "跳转页面url")
    private String page;

    @ApiModelProperty(value = "是否自定义功能",notes = "是否自定义功能")
    private Boolean isUsed;


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AppMenuConfig that = (AppMenuConfig) o;
        return userId.equals(that.userId) &&
                menuKey.equals(that.menuKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), userId, menuKey);
    }
}
