package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 企业基本信息
 *
 * @author duanwei
 * @date 2020-07-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("rpm_company")
@ApiModel(value = "Company对象", description = "企业基本信息")
public class Company extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "名称")
    private String name;
    @ApiModelProperty(value = "联系人")
    private String contact;
    @ApiModelProperty(value = "手机号码")
    private String phone;
    @ApiModelProperty(value = "固定电话")
    private String tel;
    @ApiModelProperty(value = "客服电话")
    private String servicePhone;
    @ApiModelProperty(value = "网址")
    private String website;
    @ApiModelProperty(value = "邮箱")
    private String email;

    @ApiModelProperty(value = "地区key")
    private String region;
    @TableField(exist = false)
    private String regionLabel;

    @ApiModelProperty(value = "简介")
    private String introduction;
    @ApiModelProperty(value = "logo")
    @ImagePrefix
    private String logo;
    @ApiModelProperty(value = "综合评分")
    private Float compositeScore;
    @ApiModelProperty(value = "项目类型（0-分包商，1-非分包商）")
    private String typeKey;
    @ApiModelProperty(value = "状态id")
    private Integer status;
    @ApiModelProperty(value = "企业二维码")
    private String qrcode;
    @ApiModelProperty(value = "操作业务类型")
    private Integer bizType;
    @ApiModelProperty(value = "提交日期")
    private Date approveData;
    @ApiModelProperty(value = "是否已读")
    private Integer isRead;
    @ApiModelProperty(value = "审查人id")
    private String operatorId;
    @ApiModelProperty(value = "企业性质")
    private String enterpriseNature;
    @ApiModelProperty(value = "国家")
    private String country;
    @ApiModelProperty(value = "固定总资产")
    private String totalFixedAssets;
    @ApiModelProperty(value = "总人数")
    private Integer total;
    @ApiModelProperty(value = "技术人员总数")
    private Integer techniciansNum;
    @ApiModelProperty(value = "销售电话")
    private String salesPhone;
    @ApiModelProperty(value = "拟制技术标准")
    private String preparationTechnology;
    @ApiModelProperty(value = "主要产品类型")
    private String mainProductsType;
    @ApiModelProperty(value = "历史沿革")
    private String history;
    @ApiModelProperty(value = "主要检测设备")
    private String detectionEquipment;
    @ApiModelProperty(value = "重大研制记录")
    private String developmentRecord;
    @ApiModelProperty(value = "备注")
    private String remark;
    @ApiModelProperty(value = "资质描述")
    private String qualification;
    @ApiModelProperty(value = "是否删除")
    private Integer isDelete;
    @ApiModelProperty(value = "删除日期")
    private Date deleteDate;
    @ApiModelProperty(value = "删除人id")
    private String deleteUserId;
    @ApiModelProperty(value = "删除原因")
    private String deleteCase;
    @ApiModelProperty(value = "删除人名称")
    private String deleteUserName;
    @ApiModelProperty(value = "移除人id")
    private String removeUserId;
    @ApiModelProperty(value = "移除人姓名")
    private String removeUserName;
    @ApiModelProperty(value = "移除日期")
    private Date removeDate;
    @ApiModelProperty(value = "是否在黑名单(0-否，1-是)")
    private Boolean inBlackList;
    @ApiModelProperty(value = "组织机构")
    private String orgCode;
    @ApiModelProperty(value = "公司orgcode")
    private Integer companyOrgCode;
}
