package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 作业活动关联附件
 *
 * @author duanwei
 * @date 2020-07-03
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_task_person_file")
@ApiModel(value = "TaskPersonFile对象", description = "作业活动关联附件")
public class TaskPersonFile extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "任务id")
    private Long taskId;
    @ApiModelProperty(value = "人员id")
    private Long personId;
    @ApiModelProperty(value = "人员类型")
    private String personType;
    @ApiModelProperty(value = "文件名称")
    private String fileName;
    @ApiModelProperty(value = "文件路径")
    @ImagePrefix
    private String filePath;
    @ApiModelProperty(value = "数据更新时间")
    @TableField(value = "update_date", fill = FieldFill.UPDATE)
    private Date updateDate;
}
