package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 薪资确认附件表
 *
 * @author duanwei
 * @date 2020-12-08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_task_salary_confirm_attachment")
@ApiModel(value = "TaskSalaryConfirmAttachment对象", description = "薪资确认附件表")
public class TaskSalaryConfirmAttachment extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "任务id")
	private Long taskId;

	@ImagePrefix
	@ApiModelProperty(value = "附件")
	private String attachment;

	public TaskSalaryConfirmAttachment(Long taskId, String attachment) {
		this.taskId = taskId;
		this.attachment = attachment;
	}

}
