package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 作业活动关联技术文档
 *
 * @author duanwei
 * @date 2020-07-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_task_tech_document")
@ApiModel(value = "TaskTechDocument对象", description = "作业活动关联技术文档")
public class TaskTechDocument extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "任务id")
    private Long taskId;
    @ApiModelProperty(value = "技术文档id")
    private Long techDocumentId;
    @ApiModelProperty(value = "技术文档名称")
    private String techDocumentName;
    @ApiModelProperty(value = "行业")
    private String industryType;
}
