package com.yeejoin.precontrol.common.enums;

import java.util.Arrays;
import java.util.Optional;

/**
 * @author DELL
 */

public enum  MyTodoAppMenuEum {
    /**
     * 知识推送 ,code 需要与平台app功能菜单 path一致
     */
    technology("工程交底","technology","0"),
    three2("三交三查","three2","1"),
    violateCheck("违章管理","violateCheck","2"),
    myExam("我的试题","myExam",""),
    wages("薪资确认","wages",""),
    konwledgePush("知识分享","konwledgePush","6"),
    personVerify("人员审核","personVerify",""),
    riskWork("风险作业","riskWork",""),
    riskTech("技术交底","riskTech","");
    private String name;

    private String code;

    private String type;
    MyTodoAppMenuEum(String name, String code, String type){
        this.name = name;
        this.code = code;
        this.type = type;
    }

    MyTodoAppMenuEum getEumByCode(String code ){
        MyTodoAppMenuEum eum = null;
        Optional<MyTodoAppMenuEum> op = Arrays.stream(MyTodoAppMenuEum.values()).
                filter(e->e.getCode().equals(code)).findFirst();
        if(op.isPresent()){
            eum = op.get();
        }
        return eum;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }
}
