package com.yeejoin.precontrol.common.enums;

import java.util.ArrayList;
import java.util.List;

public enum OpsLogEnum {

	NULL("", "空"),

	EDIT_PERSON("edit_person", "编辑人员"),

	DELETE_PERSON("delete_person", "删除人员"),

	EDIT_COMPANY("edit_company", "编辑公司"),

	DELETE_COMPANY("delete_company", "删除公司"),

	EDIT_PROJECT("edit_project", "编辑项目"),

	DELETE_PROJECT("delete_project", "删除项目"),

	EDIT_RISKCONTROL("edit_riskControl", "编辑风险计划"),

	DELETE_RISKCONTROL("delete_riskControl", "删除风险计划"),

	EDIT_RISKWORK("edit_riskWork", "编辑风险作业"),

	DELETE_RISKWORK("delete_riskWork", "删除风险作业"),

	EDIT_HAZARDOUSWORK("edit_hazardousWork", "编辑危险作业"),

	DELETE_HAZARDOUSWORK("delete_hazardousWork", "删除危险作业");

	private String label;
	private String value;

	OpsLogEnum(String label, String value) {
		this.label = label;
		this.value = value;
	}

	public String getLabel() {
		return label;
	}

	public void setLabel(String label) {
		this.label = label;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public static String getLabelByValue(String value) {
		String label = null;
		for (OpsLogEnum type : OpsLogEnum.values()) {
			if (type.getValue().equals(value)) {
				label = type.getLabel();
				break;
			}
		}
		return label;
	}

	public static List<OpsLogEnum> getDeleteGroup() {
		List<OpsLogEnum> ops = new ArrayList<OpsLogEnum>();
		for (OpsLogEnum type : OpsLogEnum.values()) {
			if (type.getLabel().contains("delete")) {
				ops.add(type);
			}
		}
		return ops;
	}
}
