package com.yeejoin.precontrol.common.enums;

/*
 * 惩罚状态
 */
public enum RetributionEum {
    /*
     * 未交罚款
     */
    UNPAID_FINE("未交罚款", 0),
    /*
     * 已交罚款
     */
    FINE_PAID("已交罚款", 1);

    private String label;
    private Integer value;

    RetributionEum(String label, Integer value) {
        this.label = label;
        this.value = value;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Integer getValue() {
        return value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public static String getLabelByValue(Integer value) {
        String label = null;
        for (RetributionEum type : RetributionEum.values()) {
            if (type.getValue().equals(value)) {
                label = type.getLabel();
                break;
            }
        }
        return label;
    }
}
