package com.yeejoin.precontrol.common.enums;

public enum TaskRiskTechStageEnum {

	UN_START("0", 0),

	SELECT_PERSON_EXAM_KNOWLEDGE("1", 1),
	
	COMPLETED("99", 99);

	private String label;
	private Integer value;

	TaskRiskTechStageEnum(String label, Integer value) {
		this.label = label;
		this.value = value;
	}

	public String getLabel() {
		return label;
	}

	public void setLabel(String label) {
		this.label = label;
	}

	public Integer getValue() {
		return value;
	}

	public void setValue(Integer value) {
		this.value = value;
	}

	public static String getLabelByValue(Integer value) {
		String label = null;
		for (SexEum type : SexEum.values()) {
			if (type.getValue().equals(value)) {
				label = type.getLabel();
				break;
			}
		}
		return label;
	}

	public static TaskRiskTechStageEnum getEnumByValue(Integer value) {
		for (TaskRiskTechStageEnum enums : TaskRiskTechStageEnum.values()) {
			if (enums.getValue().equals(value)) {
				return enums;
			}
		}
		return null;
	}

	public static TaskRiskTechStageEnum next(Integer value) {
		if (value == TaskRiskTechStageEnum.SELECT_PERSON_EXAM_KNOWLEDGE.getValue()) {
			return TaskRiskTechStageEnum.COMPLETED;
		} else {
			return getEnumByValue(++value);
		}
	}

	public static TaskRiskTechStageEnum previous(Integer value) {
		if (value == TaskRiskTechStageEnum.COMPLETED.getValue()) {
			return TaskRiskTechStageEnum.SELECT_PERSON_EXAM_KNOWLEDGE;
		} else if (value == TaskRiskTechStageEnum.SELECT_PERSON_EXAM_KNOWLEDGE.getValue()) {
			return TaskRiskTechStageEnum.SELECT_PERSON_EXAM_KNOWLEDGE;
		} else {
			return getEnumByValue(--value);
		}
	}
}
